<?php
// Start the session
session_start();
if ($_SESSION["email"] =='') {
  header("Location: index.html");
}else{
?>
<!doctype html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Responsive -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
    <title>Invoice</title>

    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="keywords" content="">

    <!--CSS -->

    <!--<link type="text/css" rel="stylesheet" href="css/all.css"/>-->

    <style>
        @font-face {
            font-family: 'Penna-Regular';
            src: url('invoice fonts/Penna.eot?#iefix') format('embedded-opentype'), url('invoice fonts/Penna.woff') format('woff'),
            url('invoice fonts/Penna.ttf') format('truetype'), url('invoice fonts/Penna.svg#Penna-Regular') format('svg');
            font-weight: normal;
            font-style: normal;
        }

        @font-face {
            font-family: 'Poppins-Light';
            src: url('invoice fonts/Poppins-Light.eot?#iefix') format('embedded-opentype'), url('invoice fonts/Poppins-Light.woff') format('woff'),
            url('invoice fonts/Poppins-Light.ttf') format('truetype'), url('invoice fonts/Poppins-Light.svg#Poppins-Light') format('svg');
            font-weight: normal;
            font-style: normal;
        }

        @font-face {
            font-family: 'Poppins-Medium';
            src: url('invoice fonts/Poppins-Medium.eot?#iefix') format('embedded-opentype'), url('invoice fonts/Poppins-Medium.woff') format('woff'),
            url('invoice fonts/Poppins-Medium.ttf') format('truetype'), url('invoice fonts/Poppins-Medium.svg#Poppins-Medium') format('svg');
            font-weight: normal;
            font-style: normal;
        }

        html {
            font-size: 16px;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        body {
            width: 100%;
            height: 100%;
            margin: 0;
        }

        h1, h2, h3, h4, h5, h6 {
            /*color: $purple;*/
            font-family: 'Poppins-Light', sans-serif;
        }

        h1 {
            font-size: 5rem;
        }

        h2 {
            font-size: 4.735rem;
        }

        h3 {
            font-size: 12px;
            margin: 2px 0;
        }

        h4 {
            font-size: 14px;
            margin: 0;
            margin-top: 5px;
            text-align: left;
        }

        h5 {
            font-size: 12px;
            margin: 0.15rem auto;
        }

        h6 {
            font-size: 10px;
            margin: 0;
        }

        p {
            font-size: 1.825rem;
        }

        header .row {
            display: table;
            width: 100%;
        }

        .logo, .brand-name, .bill-no {
            display: table-cell;
            text-align: center;
            vertical-align: middle;
        }

        .logo {
            display: inline-block;
            clear: both;
        }

        .logo img {
            /*padding: 3rem;*/
            /*background-color: black;*/
            float: left;
            left: 0;
            width: 2rem;
        }

        .bill-no {
            vertical-align: top;
            padding: 0.5rem;
            padding-bottom: 0;
        }

        .brand-name {
            text-align: left;
            display: inline-block;
            margin-left: 5%;
        }

        .brand-name h2 {
            font-family: 'Penna-Regular', sans-serif;
            font-size: 18px;
            text-transform: uppercase;
            font-weight: bold;
        }

        .bill-no h5 {
            font-family: 'Poppins-Medium', sans-serif;
            right: 0;
            text-align: left;
        }

        .sec-1, .sec-2, .sec-3 {
            margin: 0.5rem;
            position: relative;
        }

        .address, .date-time {
            display: inline-block;
        }

        .date-time {
            right: 0;
            float: right;
            text-align: right;
            position: absolute;
        }

        .table th, .table td {
            text-align: center;
        }

        .table th:first-child, .table td:first-child {
            text-align: left;
        }

        .table th:last-child, .table td:last-child {
            /*float: right;*/
            text-align: right;
        }

        .table > tbody > tr > td,
        .table > tbody > tr > th,
        .table > tfoot > tr > td,
        .table > tfoot > tr > th,
        .table > thead > tr > td,
        .table > thead > tr > th {
            border-bottom: 0 solid transparent;
            border-top: 0 solid transparent;
        }

        .table > thead {
            border-bottom: 1px solid grey;
        }

        .table > thead > tr > th > h5 {
            text-align: right;
        }

        .table > tbody > tr > td > h5 {
            font-weight: bold;
            margin: 0.05rem auto;
            text-align: right;
        }

        .table > tbody > tr > td:first-child > h5, .table > thead > tr > th:first-child > h5 {
            text-align: left;
        }

        .heading, .amount, .rcv-amount, .cash-back {
            display: inline-block;
        }

        .amount, .rcv-amount, .cash-back  {
            float: right;
        }

        .heading h4, .amount h4, .heading h3, .rcv-amount h3, .cash-back h3 {
            font-family: "Poppins-Light", sans-serif;
        }

        .conditions > ul {
            font-size: 9px;
            padding-left: 1rem;
        }

        .conditions > ul > li > h5 {
            font-weight: bold;
        }

        footer {
            text-align: center;
            margin-top: 10px;
            position: relative;
            width: 100%;
        }

        footer .thanks h5 {
            font-weight: bold;
        }

        footer .barcode {
            margin: 2% 0;
        }

        #section-to-print {
            margin: 0 auto;
            width: 250px;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            #section-to-print, #section-to-print * {
                visibility: visible;
            }

            #section-to-print {
                position: absolute;
                left: 0;
                top: 0;
            }
        }

    </style>
</head>
<body onload="window.print();">
<div id="section-to-print" class="">
    <header>
        <div class="container-fluid">
            <div class="row">
                <div class="logo">
                    <img src="<?php echo base_url(); ?>assets/images/logo.png"/>
                </div>
                <div class="brand-name">
                    <h2>umer sohail</h2>
                </div>
            </div>
            <div class="row">
                <div class="bill-no">

                    <h4>Bill # <span class="num"><?php echo $invoice->invoice_id;?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $invoice->type;?> </span></h4>
                </div>
            </div>
        </div>
    </header>
    <article>
        <section class="sec-2">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <table id="" class="table"
                               cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>
                                    <h5>Item Name</h5>
                                </th>
                                <th>
                                    <h5>Qty</h5>
                                </th>
                                <th>
                                    <h5>Rate</h5>
                                </th>
                                <th>
                                    <h5>Disc.</h5>
                                </th>
                                <th>
                                    <h5>Total</h5>
                                </th>
                            </tr>
                            </thead>
                            <tbody>


                            <?php foreach ($invoice_details as $invoice_detail) {?>
                                <tr>
                                    <td>
                                        <h5><?php echo $invoice_detail->item_title;?></h5>
                                    </td>
                                    <td>
                                        <h5><?php echo $invoice_detail->quantity;?></h5>
                                    </td>
                                    <td>
                                        <h5><?php echo $invoice_detail->item_price;?></h5>
                                    </td>
                                    <td>
                                        <h5><?php echo $invoice_detail->discount_amount;?></h5>
                                    </td>
                                    <td>
                                        <h5><?php echo $invoice_detail->net_value;?></h5>
                                    </td>
                                </tr>
                            <?php } ?>


                            </tbody>
                        </table>
                    </div>
                </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="" style="border-bottom: 1px solid lightgrey; border-top: 1px solid lightgrey">
                                    <div class="heading">
                                        <h4>Total Amount</h4>
                                    </div>
                                    <div class="amount">
                                        <h4>
                                            <span><?php echo $invoice->net_receivable;?></span> PKR
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="heading">
                                    <h3>Received Amount</h3>
                                </div>
                                <div class="rcv-amount">
                                    <h3> <span><?php echo $invoice->receive_amount;?></span> PKR</h3>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="border-bottom: 1px solid lightgrey">
                            <div class="col-md-12">
                                <div class="heading">
                                    <h3>Cash Return</h3>
                                </div>
                                <div class="cash-back">
                                    <h3> <span><?php echo $invoice->cash_back;?></span> PKR</h3>
                                </div>
                            </div>
                        </div>


<!--                        <div class="tfoot">-->
<!--                            <div class="heading">-->
<!--                                <h4>Total Amount</h4>-->
<!--                            </div>-->
<!--                            <div class="amount">-->
<!--                                <h4>-->
<!--                                    <span>--><?php //echo $invoice->net_receivable;?><!--</span> PKR-->
<!--                                </h4>-->
<!--                            </div>-->
<!--                        </div>-->

            </div>
        </section>
        <section class="sec-3">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="conditions">
                            <ul>
                                <li>
                                    <h5>No return with cash applicable</h5>
                                </li>
                                <li>
                                    <h5>No exchange after 5 days</h5>
                                </li>
                                <li>
                                    <h5>Return must be in new condition</h5>
                                </li>
                                <li>
                                    <h5>Return must be with original invoice</h5>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="sec-1">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="address">
                            <h6>
                                Shop # 10
                            </h6>
                            <h6>
                                Gulberg Galleria, Lahore
                            </h6>
                        </div>
                        <div class="date-time">
                            <h6 class="date">
                               <?php echo date('y-m-d');?>
                            </h6>
                            <h6 class="time">
                                <?php echo date('H:m:s:i');?>
                            </h6>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </article>
    <footer>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="thanks">
                        <h5>THANKS FOR SHOPPING AT UMER SOHAIL</h5>
                    </div>
                    <div class="barcode">
                       <h5>042-35776888</h5>
                    </div>
                    <div class="developers">
                        <h5>Software By: www.half-tech.com</h5>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
</body>

</html>
<?php } ?>